/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.components;

import java.awt.Component;
import java.util.Vector;
import jclass.datasource.DataModel;
import jclass.datasource.DataModelException;
import jclass.datasource.DataTableModel;
import jclass.datasource.MetaDataModel;
import jclass.datasource.components.DataBinding;
import jclass.datasource.components.ExceptionManager;
import jclass.datasource.treemodel.TreeNode;

public abstract class NavigatorDataBinding
extends DataBinding {
    public NavigatorDataBinding(Component component) {
        super(component);
    }

    public NavigatorDataBinding(Component component, DataModel dataModel, MetaDataModel metaDataModel) {
        super(component);
        this.setDataBinding(dataModel, metaDataModel);
    }

    public boolean addRow() {
        try {
            this.dataTableModel.addRow(this);
            this.moveToRowIndex(this.getNumRows() - 1);
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean deleteRow() {
        int n = this.getCurrentRowIndex();
        if (n >= 0) {
            return this.deleteRows(n, 1);
        }
        return false;
    }

    public boolean deleteRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            Vector<Long> vector = new Vector<Long>(n2);
            int n3 = n;
            while (n3 < n + n2) {
                vector.addElement(new Long(this.dataTableModel.getRowIdentifier(n3)));
                ++n3;
            }
            int n4 = 0;
            while (n4 < vector.size()) {
                this.dataTableModel.deleteRow(this, ((Long)vector.elementAt(n4)).intValue());
                ++n4;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean requeryRow() {
        int n = this.getCurrentRowIndex();
        if (n >= 0) {
            return this.requeryRows(n, 1);
        }
        return false;
    }

    public boolean requeryRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                this.dataTableModel.requeryRow(this, this.dataTableModel.getRowIdentifier(n3));
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean requeryRowAndDetails() {
        int n = this.getCurrentRowIndex();
        if (n >= 0) {
            return this.requeryRowsAndDetails(n, 1);
        }
        return false;
    }

    public boolean requeryRowsAndDetails(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                this.dataTableModel.requeryRowAndDetails(this, this.dataTableModel.getRowIdentifier(n3));
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean requeryAll() {
        try {
            this.dataModel.requeryAll(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean cancelRow() {
        int n = this.getCurrentRowIndex();
        if (n >= 0) {
            return this.cancelRows(n, 1);
        }
        return false;
    }

    public boolean cancelRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                this.dataTableModel.cancelRowChanges(this, this.dataTableModel.getRowIdentifier(n3));
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean cancelAll() {
        try {
            this.dataModel.cancelAll(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean commitRow() {
        int n = this.getCurrentRowIndex();
        if (n >= 0) {
            return this.commitRows(n, 1);
        }
        return false;
    }

    public boolean commitRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                this.dataTableModel.commitRow(this, this.dataTableModel.getRowIdentifier(n3));
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public boolean commitAll() {
        try {
            this.dataModel.updateAll(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public Object getTableRowLabel(int n) {
        return String.valueOf(n) + (this.isRowModified(n) ? "*" : "  ");
    }

    public Object getTableColumnLabel(int n) {
        try {
            return this.metaDataModel.getColumnIdentifier(n);
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return null;
        }
    }

    public Object getResultData(int n, int n2) {
        try {
            return this.dataTableModel.getResultData(this.dataTableModel.getRowIdentifier(n), this.metaDataModel.getColumnIdentifier(n2));
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return null;
        }
    }

    public boolean updateCell(Object object, int n, int n2) {
        try {
            this.dataTableModel.updateCell(this, this.dataTableModel.getRowIdentifier(n), this.metaDataModel.getColumnIdentifier(n2), object);
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    public int getJavaColumnType(String string) {
        try {
            return this.metaDataModel.getJavaColumnType(string);
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return -1;
        }
    }

    public boolean isRowModified(int n) {
        return this.dataTableModel.getRowStatus(this.dataTableModel.getRowIdentifier(n)) != 4;
    }

    public int getRowStatus(int n) {
        return this.dataTableModel.getRowStatus(this.dataTableModel.getRowIdentifier(n));
    }

    public boolean requeryLevel() {
        try {
            if (this.dataTableModel == null) {
                this.dataModel.requeryAll(this);
            } else {
                long l = this.dataTableModel.getParentBookmark();
                if (l == -1L) {
                    this.dataModel.requeryAll(this);
                } else {
                    MetaDataModel metaDataModel = (MetaDataModel)((TreeNode)((Object)this.metaDataModel)).getParent();
                    DataTableModel dataTableModel = this.dataModel.getCurrentDataTable(this, metaDataModel);
                    dataTableModel.requeryRowAndDetails(this, l);
                }
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    protected void setDataAvailable(boolean bl) {
        boolean bl2 = this.component.isEnabled();
        bl = this.isEnabled();
        if (bl != bl2) {
            this.component.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.dataModel != null && this.metaDataModel != null;
    }

    public boolean isAvailable() {
        return this.isDataAvailable();
    }
}

